// Aqua Template JavaScript - Basic interactivity

document.addEventListener('DOMContentLoaded', function() {
    // Add click event listeners to aqua buttons
    const buttons = document.querySelectorAll('.aqua-button');

    buttons.forEach(button => {
        button.addEventListener('click', function(e) {
            const text = this.textContent.toLowerCase();

            // Handle navigation buttons
            if (text === 'home') {
                e.preventDefault();
                document.getElementById('hero').scrollIntoView({ behavior: 'smooth' });
            } else if (text === 'about') {
                e.preventDefault();
                document.getElementById('about').scrollIntoView({ behavior: 'smooth' });
            } else if (text === 'contact') {
                e.preventDefault();
                document.getElementById('contact').scrollIntoView({ behavior: 'smooth' });
            } else if (text === 'get started') {
                e.preventDefault();
                document.querySelector('.content').scrollIntoView({ behavior: 'smooth' });
            } else if (text === 'send message') {
                // Form submission handled separately
                return;
            } else {
                // Simple alert for other buttons
                alert(`You clicked: ${this.textContent}`);
            }

            // Add a ripple effect
            this.style.transform = 'scale(0.95)';
            setTimeout(() => {
                this.style.transform = 'scale(1)';
            }, 150);
        });
    });

    // Handle contact form submission
    const contactForm = document.querySelector('.contact-form');
    if (contactForm) {
        contactForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const name = this.querySelector('input[type="text"]').value;
            const email = this.querySelector('input[type="email"]').value;
            const message = this.querySelector('textarea').value;

            if (name && email && message) {
                alert(`Thank you, ${name}! Your message has been sent. We'll get back to you at ${email} soon.`);
                this.reset();
            } else {
                alert('Please fill in all fields.');
            }
        });
    }

    // Add some dynamic styling on load
    const cards = document.querySelectorAll('.card');
    cards.forEach((card, index) => {
        card.style.animationDelay = `${index * 0.1}s`;
        card.style.animation = 'fadeInUp 0.6s ease-out forwards';
    });
});

// Add CSS animation for cards
const style = document.createElement('style');
style.textContent = `
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
`;
document.head.appendChild(style);
